//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

UiDialog {
    id : choiceDialog

    property list<UiChoice> choices

    flags : UiDialog.RejectOnClickOutside  |
            UiDialog.RejectOnEscape |
            UiDialog.RejectOnCloseEvent

    headerDelegate : Rectangle {
        implicitHeight : 50
        color : UiColors.getColor(UiColors.HeaderGrey4)

        Text {
            id : label

            font : UiFonts.getFont(UiFonts.Light, 18)
            anchors {
                left : parent.left
                right : parent.right
                margins : 10

                verticalCenter : parent.verticalCenter
            }
            text : choiceDialog.label
            color : UiColors.getColor(UiColors.DialogHeaderText)
            horizontalAlignment : Qt.AlignHCenter
        }
    }

    onOpened : {
        const availableChoices = [];
        for (let i = 0; i < choices.length; ++i) {
            if (choices[i].visible) {
                availableChoices.push(choices[i]);
            }
        }
        // Only one choice available - auto-trigger
        if (availableChoices.length === 1) {
            accept(availableChoices[0]);
            availableChoices[0].clicked();
        }
    }

    contentDelegate : Row {
        padding : 8
        spacing : 17

        Repeater {
            model : choiceDialog.choices
            delegate : UiButton {
                id : button

                visible : modelData.visible
                width : Math.max(128, content.implicitWidth)
                height : content.implicitHeight

                onClicked : {
                    choiceDialog.accept(modelData);
                    modelData.clicked();
                }

                UiVerticalSeparator {
                    anchors {
                        right : parent.right
                        rightMargin : -9
                        top : parent.top
                        topMargin : 4
                        bottom : parent.bottom
                        bottomMargin : 4
                    }
                    visible : !parent.Positioner.isLastItem
                    color : UiColors.getColor(UiColors.Black, .09)
                }

                Column {
                    id : content

                    spacing : 6
                    padding : 8
                    topPadding : 11
                    bottomPadding : 16
                    anchors.fill : parent

                    Image {
                        source : modelData.icon
                        anchors.horizontalCenter : parent.horizontalCenter
                    }

                    UiText {
                        text : modelData.text
                        highlight : button.pressed
                        font : UiFonts.getFont(UiFonts.Light, 18)
                        anchors.horizontalCenter : parent.horizontalCenter
                    }
                }
            }
        }
    }

    footerDelegate : null
}
